this.name = "Deep Horizon - Pirate_Ambushes";
this.author	= "Blake Deakins - a.k.a. Cmd. Cheyd";
this.description = "Allow pirates in low-government and anarchy systems to ambush new arrivals by trapping them inside a moon's gravity well";
this.version = "1.0.2";
this.copyright = " Creative Commons Attribution-NonCommercial-NoDerivs 3.0 United States License (Modified)";

// ********************* DEBUGGING VARIABLES  *********************
// These variables are for this.dbg_Pirate_Ambushes_Scriptging purposes only.  Some of them
// can cause significant decrease in system speed while enabled.  
// Enabling of these options is not recommended unless you are
// familiar with scripting.
this.dbg_Pirate_Ambushes_Script = false;
this.dbg_Moon_Positioning = false;
this.dbg_Ambushes = false;
this.dbg_PseudoRandom_Generation = false;
// ***************************************************************

this.startUp = this.reset = function()
{
	log("Initialising OXP " + this.name);
	if (!worldScripts["Deep Horizon - Systems"]) player.commsMessage("Unable to load OXP: Pirate Ambushes.  This oxp requires Deep Horizon - Systems", 10);
}

this.checkForAmbush = function(seedGovernment) {
	var playerChanceAmbush = Math.random();
	var systemChanceAmbush = 0.28-(0.11*seedGovernment);
	if(playerChanceAmbush <= systemChanceAmbush) {
		var ambushPresent = Math.random();
		if (ambushPresent <= (0.7-(0.2*seedGovernment)) && worldScripts["System Redux 2"].systemDone == false) {
			if(this.dbg_Pirate_Ambushes_Script == true && (this.dbg_PseudoRandom_Generation == true || this.dbg_Ambushes == true)) {
				log(this.name,"Player Ambush number is: " + playerChanceAmbush + ".  System Ambush chances is: "+ systemChanceAmbush + ".");
				log(this.name,"Pirate Ambush Triggered.  Ambush Roll was :" + ambushPresent + ".  System Chance was: " + (0.7-(0.2*seedGovernment)) + ".");
			}
			this.pirateAmbush();
		}
	}
}

this.pirateAmbush = function() {
	// Okay genius... Now, how do you add pirates to a system??
	var Num_Pirates = 4 - system.government;
	Num_Pirates += (Math.ceil(player.score/667) - 2);
	if(Num_Pirates >=9) {
		Num_Pirates = 8;
	}
	system.legacy_addShipsWithinRadius('pirate',Num_Pirates,'abs',player.ship.position,25600);
	// Sensor feedback of system makeup
	if (player.ship.equipmentStatus("EQ_ADVANCED_COMPASS") === "EQUIPMENT_OK") {
			player.consoleMessage("System Witchspace Beacon has been moved.  Please alert the nearest GalCop facility.", 5);
	}
	if(this.dbg_Pirate_Ambushes_Script == true && this.dbg_Ambushes == true) {
		log(this.name,"Adding " + Num_Pirates + " pirates in radius of the player.");
	}
}

